/****************************************************************************
*
*	timer.cpp:	Implementation of timer object.
*			Uses timeofday to record start time and end time,
*			and prints the timed interval.
*
*                       Sharlee Climer
*                       March 14, 2000
*
*****************************************************************************
*
*       RCS data block
*               $Author: sclimer $
*               $Date: 2000/03/13 20:14:41 $
*               $Id: timer.cpp,v 1.1 2000/03/13 20:14:41 sclimer Exp sclimer $
*               $RCSfile: timer.cpp,v $
*               $Revision: 1.1 $
*
****************************************************************************/
    

#include "timer.h"


Timer::Timer()			// Constructor
{
   if ((tp = new timeval) == NULL)
      cout << "Error allocating pointer." << endl;
}              

void Timer::startTimer()	// Start timer.
{
   
   if (gettimeofday(tp, NULL) != 0)         
      cout << "Error getting time." << endl;

   startmicrosec = tp->tv_usec;
   startsec = tp->tv_sec;    
}

void Timer::endTimer()		// End timer and print duration.
{
   
   if (gettimeofday(tp, NULL) != 0)        
      cout << "Error getting time." << endl;

   endmicrosec = tp->tv_usec;
   endsec = tp->tv_sec;    
   interval = endsec - startsec;
   interval += (float)endmicrosec/1000000 - (float)startmicrosec/1000000;
   cout << "computation time = " << interval << " seconds." << endl;    
}
