/****************************************************************************
*
*	linedet.h:	Header file for line detector objects.
*
*                       Sharlee Climer
*                       December 2000
*
****************************************************************************/
    

#ifndef LINEDET_H
#define LINEDET_H

#include <iostream.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "timer.h"

const int MASKHT = 12;		// Height of mask grid.
const int MASKWIDTH = 21;	// Width of mask grid.
const int NUMSLOPES = 40;	// Number of discrete slopes on mask.
const float MINPOINTS =9;	// Minimum number of points in 10-pixel line.
const int MAXNUMLINES = 10000;	// Maximum number of lines in an image.
const int TEST = 0;		// TEST = 1 to print values.
const int SLOPETOL = 2;		// Tolerance for slope differences between
				// catenated segments.
const float DELTOL = 0.4;	// tolerance for deleting pixels on lines.
//const int BLOB = 4;           // If more than BLOB lines in fan, ignore fan.
const int printText = 1;	// If printText=0, only coordinates are
				// printed.
const int PRINTLENGTH = 0;     // Minimum length line to print.  
const float PI = 3.1416;
const float SLOPECONV[40] = {0.0, -0.1, -0.2, -0.3, -0.4, -0.5, -0.6, -0.7,
                             -0.8, -0.9, -1.0, -1.1111, -1.25, -1.4286, -1.6667,
                             -2.0, -2.5, -3.3333, -5.0, -10.0, 1000000.0,                             10.0, 5.0, 3.3333, 2.5, 2.0, 1.6667, 1.4286, 1.25,
                             1.1111, 1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3,
                             0.2, 0.1};

class Mask;

class Line
{
   public:
      Line(void);
      void startLine(int, int, int, int, float);	// Initialyze new line.
      void addSegment(int, int, float);	// New endpoint and slope of added line.
      void printLine();	
      float slope(); 		// Return average slope of line.
      void convSlope();         // Convert to actual slope & store in actSlope.
   private:
      int startRow;
      int startCol;
      int endRow;
      int endCol;
      int numSegments;		// Number of segments in line.
      float slopeSum;		// Add up slopes (divide by numSegments at end).
      float actSlope;
      float length;
};

class Image 
{
   public:
      Image(void);
      ~Image();
      int numberRows();		// Return number of rows.
      int numberCols();		// Return number of columns.
      int value(int, int);	// Return value of pixel.
      void applyMask(int, int, Mask);	// Apply mask to given point.
      void findLines(int, int, Line[], Mask); // Find lines and update lines[]. 
      void clearTallies();	// Set tallies of edge pixels to zero.
      void deleteLine(int, int, int, int, int, int, Mask); 
				// Delete pixels in line.
      void printLines(Line[]);
      void convertSlopes(Line[]); // Find actual slopes of lines.      
   private:
      int numRows, numCols;
      int *image;
      float tallies[NUMSLOPES];
      char filename[100];
      FILE *imPtr;
      int newLinePtr;
};

class Mask
{
   public:
      Mask(void);
   private:
      friend class Image;		// Grant access to Image class.
      float wt[NUMSLOPES][MASKHT][MASKWIDTH];
      float slopes[NUMSLOPES];  // Use for slope conversion.
      FILE *maskPtr;
};   

#endif


