/****************************************************************************
*
*	linedet.cpp:	Implementation of line detector objects.
*
*                       Sharlee Climer
*                       December 2000
*
****************************************************************************/
    

#include "linedet.h"


Line::Line()
{
   numSegments = 0;		// Initialyze variables.
   slopeSum = 0;
   length = 0;
}

void Line::startLine(int stRow, int stCol, int stopRow, int stopCol, float slope)
{
   startRow = stRow;
   startCol = stCol;
   endRow = stopRow;
   endCol = stopCol;
   numSegments++;
   slopeSum += slope;
}

void Line::addSegment(int row, int col, float newSlope) // Add a new line segment.
{
   endRow = row;
   endCol = col;
   numSegments++;
   slopeSum += newSlope;
}

float Line::slope()		// Return average slope of line.
{
   return (slopeSum / float(numSegments));
}

void Line::convSlope()          // Find actual slope and store in actSlope.
{
  float m = slopeSum / (float)(numSegments);
  int index = (int)(m);
  actSlope = SLOPECONV[index] + (m - (float)index) *
    (SLOPECONV[index+1] - SLOPECONV[index]);
}

void Line::printLine()
{
   if (printText)
   {
      int l = int(sqrt(pow((startRow-endRow),2)+pow((startCol-endCol),2)));
      if (l < PRINTLENGTH)   return;
      cout << "start point: (" << startRow-9 << ", " << startCol-9 << ")\t";
      cout << "end point: (" << endRow-9 << ", " << endCol-9 << ")\n";
      //cout << "length: " << l << '\n'; 
      //      cout.precision(2);
      //cout << "slope: " << actSlope << "\t";
      //      cout << "slope: " << slopeSum / float(numSegments) << '\n';
      //cout << "degrees: " << (int)(atan(actSlope)*180.0/PI) << "\n";        
   }

   else
   {
      cout << startRow-9 << '\t' << startCol-9 << '\t';
      cout << endRow-9 << '\t' << endCol-9 << endl;
   }
}

Mask::Mask()			// Constructor.
{
   if ((maskPtr = fopen("mask", "r")) == NULL)
   {
      cout << "File could not be opened.\n";
      exit(EXIT_FAILURE);
   }                                     

   for (int i=0; i<NUMSLOPES; i++)
   {
      for (int j=0; j<MASKHT; j++)
      {
         for (int k=0; k<MASKWIDTH; k++)
         {
            fscanf(maskPtr, "%f", &(wt[i][j][k]));
            if (TEST)   cout << wt[i][j][k] << "  ";
         }

         if (TEST)  cout << '\n';
      }
         if (TEST)
            cout << '\n';
   }                          

   fclose(maskPtr);
}
