/****************************************************************************
*
*	line.cpp:	Program to detect lines in binary images (output 
*			of an edge detector) and output the endpoints, 
*			slope, and length of the lines.
*
*                       Sharlee Climer
*                       December 2000
*
****************************************************************************/
    

#include "linedet.h"
#include <iostream.h>

int main(void)
{
   Image image;		// Create copy of binary image.
   Mask mask;		// Create mask.
   int numRows = image.numberRows();	// Get number of rows & columns.
   int numCols = image.numberCols();
   Line lines[MAXNUMLINES+2];		// Hold lines when found.
   Timer time;

//   time.startTimer();

   for (int i=1; i<numRows-10; i++)	// Scan image row by row for edges.
   {
      for (int j=10; j<numCols-10; j++)
      {
         if (image.value(i, j) > 0)		// If edge point.
         {
	   //cout << "(" << i-9 << ", " << j-9 << ") ";
            image.applyMask(i, j, mask);  // Find corresponding line segments.
            image.findLines(i, j, lines, mask); // Look for tallies>=MINPOINTS.
            image.clearTallies();	// Clear slope totals.
         }
      }
   }
   image.convertSlopes(lines);   
   //   time.endTimer();
   image.printLines(lines);

   return 1;
}
