/****************************************************************************
*
*	image.cpp:	Implementation of image objects.
*
*                       Sharlee Climer
*                       December 2000
*
****************************************************************************/
    

#include "linedet.h"


Image::Image()			// Constructor.
{
   cout << "Enter the name of the edge file: ";
   cin >> filename;

   if ((imPtr = fopen(filename, "r")) == NULL)
   {
      cout << "file could not be opened.\n";
      exit(EXIT_FAILURE);
   }
   /*temporary - for reading pgm files
   char * temp1;
   char * temp2;
   char * temp3;
   fscanf(imPtr, "%d%d%d", temp1, temp2, temp3);
   end temp*/

   cout << "Enter the number of rows in the binary image: ";
   cin >> numRows;
   cout << "Enter the number of columns in the binary image: ";
   cin >> numCols;

   numRows += 20;  numCols += 20;               // Add a 10-pixel border.
   image = new int[(numRows)*(numCols)];		// Allocate space.

   if (image==NULL)  exit(EXIT_FAILURE);	// Space not allocated.

   for (int i=0; i<10; i++)        
   {
     for (int j=0; j<numCols; j++)             // Top border.
         image[i*numCols+j] = 0;
   }

   if (1) {                        // Use if origin is top left corner.
     for (int i=10; i<numRows-10; i++)      
       {
	 for (int j=0; j<10; j++)
	   image[i*numCols+j] = 0;

	 for (int j=10; j<numCols-10; j++) {
	   fscanf(imPtr, "%d", &(image[i*numCols+j]));
	 }

	 for (int j=numCols-10; j<numCols; j++)
	   image[i*numCols+j] = 0;
       }
   }

   else {                      // Use if origin is bottom left corner.
     for (int i=numRows-11; i>9; i--)      
       {
	 for (int j=0; j<10; j++)
	   image[i*numCols+j] = 0;

	 for (int j=10; j<numCols-10; j++)
	   fscanf(imPtr, "%d", &(image[i*numCols+j]));

	 for (int j=numCols-10; j<numCols; j++)
	   image[i*numCols+j] = 0;
       }
   }

   for (int i=numRows-10; i<numRows; i++)      // Bottom border.
   {
      for (int j=0; j<numCols; j++)
         image[i*numCols+j] = 0;
   }

   if (0)                                // Print upper left-corner.
   {
      for (int i=10; i<numRows-10; i++)
      {
         for (int j=10; j<numCols-10; j++)
            cout << image[i*numCols+j];

         cout <<'\n';
      }
   }

   fclose(imPtr);
   newLinePtr = 2;		// 0 & 1 match binary data.

   for (int i=0; i<NUMSLOPES; i++)
      tallies[i] = 0.0;
}   

Image::~Image()
{
   delete [] image;
}   

int Image::numberRows()
{
   return (numRows);
}

int Image::numberCols()
{
   return (numCols);
}

int Image::value(int row, int col)
{
   return (image[row*numCols+col]);
}

void Image::applyMask(int row, int col, Mask mask)
{
   for (int i=0; i<MASKHT; i++)	// Check for edges under mask area.
   {
      for (int j=0; j<MASKWIDTH; j++)
      {
         if (image[(row-1+i)*numCols+(col-10+j)] == 1)
         {
            for (int k=0; k<NUMSLOPES; k++)  // Add up weights for each slope.
               tallies[k] += mask.wt[k][i][j];
         }
      }
   }
}

void Image::findLines(int row, int col, Line *lines, Mask mask)
{
   int endRow, endCol, value;

   value = image[row*numCols+col];

   for (int i=0; i<NUMSLOPES; i++)
   {
      int fan = 1;		// Number of lines in fan.
      int maxPts = 0;	// Line with most points in fan.

      if (tallies[i] >= MINPOINTS)	// Found a line segment.
      { 
	//cout << "(" << row-9 << ", " << col-9 << ") " << "m = " << i << ", tallies = " << tallies[i] << endl;
         while ((tallies[i+fan] >= MINPOINTS)&&(i+fan < NUMSLOPES))
				// Find # of lines in fan.
            fan++;

	 //	 if (fan > BLOB)      // Must be a blob of edge points.
	 //          continue;

         if (fan > 1)
         {
            for (int j=1; j<fan; j++)	// Find line with the most points.
            {
               if (tallies[i+j] > tallies[i+maxPts])
                  maxPts = j;
            }
   
            i += maxPts;
         }

         if (i <=10)			// Find endpoint of line segment.
         {
            endRow = row + i;
            endCol = col + 10;
         }

         if ((10 < i)&&(i < 30))
         {
            endRow = row + 10;
            endCol = col + 20 - i;
         }

         if (i >= 30)
         {
            endRow = row + 40 - i;
            endCol = col - 10;
         }

         int foundLine = 0;  // Flag to indicate if existing line is catenated.

         for (int j=row-4; j<=row+4; j++)  // Check adjacent pixels for endpts.
         {
            for (int k=col-4; k<=col+4; k++)
            {
               int adjVal = image[j*numCols+k];

               if ((adjVal > 1)&&(fabs(lines[adjVal].slope() - i) < SLOPETOL))
               {
                  lines[adjVal].addSegment(endRow, endCol, float(i));
                  deleteLine(row, col, endRow, endCol, adjVal, i, mask);
					// Delete pixels on line.
                  foundLine = 1;
		  //cout << "line is catenated" << endl;
               }
            }
         }

         if (foundLine==0)
         {
            lines[newLinePtr++].startLine(row, col, endRow, endCol, float(i));
            deleteLine(row, col, endRow, endCol, newLinePtr-1, i, mask);
   
	    //cout << "line " << newLinePtr-1 << endl;
            if (newLinePtr >= MAXNUMLINES)
            {
               cout << "More than " << MAXNUMLINES << " lines.\n";
               exit(EXIT_FAILURE);
            }
         }
      }

      i += fan-1;	// Skip to slope after fan section.
   }
}

void Image::clearTallies()
{
   for (int i=0; i<NUMSLOPES; i++)
      tallies[i] = 0;
}

void Image::deleteLine(int row, int col, int endRow, int endCol, int lineNum, int slope, Mask mask)
{
   for (int i=0; i<MASKHT; i++)
   {
      for (int j=0; j<MASKWIDTH; j++)
      {
         if (mask.wt[slope][i][j] > DELTOL)  // If point on corresponding line.
         {
            int pixel = (row-1+i)*numCols + (col-10+j);

            if (image[pixel] == 1)
               image[pixel] = 0;
         }
      }
   }

   image[endRow*numCols+endCol] = lineNum; // Mark endpt. with line#.
}

void Image::printLines(Line *lines)
{
   for (int i=2; i<newLinePtr; i++)
   {
      lines[i].printLine();
   }
   cout << "number of lines " << newLinePtr-2 << endl;
}

void Image::convertSlopes(Line *lines)
{
   for (int i=2; i<newLinePtr; i++)
   {
      lines[i].convSlope();
   }
}
