/****************************************************************************
*
*       stdinc.h:	Standard header file.
*
*                       Sharlee Climer
*                       July 2007
*
****************************************************************************/
    

#ifndef STDINC_H
#define STDINC_H

#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <time.h>

const int TRUE = 1;
const int FALSE = 0;


inline int max(int x, int y) { return x > y ? x : y; }
inline double max(double x, double y) { return x > y ? x : y; }
inline int min(int x, int y) { return x < y ? x : y; }
inline double min(double x, double y) { return x < y ? x : y; }
inline int abs(int x) { return x < 0 ? -x : x; }
inline float abs(float x) { return x < 0.0 ? -x : x; }

// Return a random number in [0,1]
inline double randfrac() { return ((double) rand()/RAND_MAX); }

inline void warning(char* p) { fprintf(stderr,"Warning: %s\n",p); }
inline void fatal(char* string) {fprintf(stderr,"Fatal: %s\n",string);
                                 exit(1); }

#endif
