/****************************************************************************
/
/
/  convert.cpp: program for converting .gml files to .list files
/
/  Sharlee Climer, July 2007
/
/
/***************************************************************************/

#include "stdinc.h"

int main(int argc, char * argv[])
{
  if (argc != 3)
    fatal("Usage:\n  gml2list inputFile.gml outputFile.list"); 

  FILE *input;
  FILE *output;
  
  if (((input = fopen(argv[1], "r")) == NULL) || ((output = fopen(argv[2], "w")) == NULL))
    fatal("File could not be opened.\n");

  int min = 1000000000;   // hold min node number
  int max = -1000000000;  // hold max node number
  char string[50];
  int startOne; // 1 if start node number is 1, 0 if start number is 0

  while (1) { // throw away everything until get to "graph" declaration
    if(feof(input)) fatal("no graph to read in input file");

    fscanf(input, "%s", string); // read in string from file

    if(strncmp(string, "graph", 5) == 0) 
      break; // stop when get to "graph" declaration
  }

  while (1) { // throw away everything until get to "edge" declaration
    if(feof(input)) fatal("no edges to read in input file");

    fscanf(input, "%s", string); // read in string from file

    if(strncmp(string, "id", 2) == 0) { 
      fscanf(input, "%s", string); // read in id value
      int num = atoi(string);

      if(min > num) min = num; // update minimum node number
      if(max < num) max = num; // update maximum node number
    }

    if(strncmp(string, "edge", 4) == 0) 
      break; // stop when read in first "edge"
  }

  cout << "\nNode numbers range from " << min <<" to " << max << ".\n" << endl;
  startOne = min;

  if(startOne < 0) fatal("Node numbers can not be negative");
  if ((startOne != 0) && (startOne != 1)) 
    warning("Smallest node number should be 0 or 1");
  if (startOne == 0) {
    cout << "  IMPORTANT: Matlab doesn't accept 0 as a node number." << endl;
    cout << "  All node numbers will be increased by 1.\n" << endl;
  }

  while (!feof(input)) { // continue until reach end of file
    fscanf(input, "%s", string); // read in string from file

    if(!strncmp(string, "[", 1) == 0) // check for correct character
      fatal("No '[' after edge declaration");

    fscanf(input, "%s", string); // read in string from file
    if(!strncmp(string, "source", 6) == 0) // check for correct character
      fatal("No 'source' declaration");

    fscanf(input, "%s", string); // read in start node from file
    int source = atoi(string);

    if((source < min) || (source > max))
      fatal("Invalid node number");

    if(startOne == 0) // increase node number by 1
      source++;

    //cout << "source: " << source;

    fscanf(input, "%s", string); // read in string from file
    if(!strncmp(string, "target", 6) == 0) // check for correct character
      fatal("No 'target' declaration");

    fscanf(input, "%s", string); // read in target node from file
    int target = atoi(string);

    if((target < min) || (target > max))
      fatal("Invalid node number");

    if(startOne == 0) // increase node number by 1
      target++;

    //cout << ", target: " << target;

    fscanf(input, "%s", string); // read in string from file

    float weight = 1.0;
    if(strncmp(string, "weight", 6) == 0) {// check to see if weight specified
      fscanf(input, "%s", string); // read in string from file
      weight = atof(string);
      fscanf(input, "%s", string); // read in string from file
    }

    //cout << ", weight: " << weight << endl;

    if(!strncmp(string, "]", 1) == 0) // check for correct character
      fatal("No ']' after edge declaration");

    fprintf(output, "%d\t%d\t%f\n", source, target, weight);

    if (feof(input)) break; // break is at end of file

    fscanf(input, "%s", string); // read in string from file

    if(strncmp(string, "]", 1) == 0) // check for end of graph
      break;

    if(!strncmp(string, "edge", 4) == 0) // check for correct character
      fatal("No 'edge' declaration");
  }

  //cout << endl;
  fclose(input);
  fclose(output);

  return 1;
}
